/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.more_bows_and_arrows.core.item;

import forge.com.cursee.more_bows_and_arrows.core.tier.BowTier;
import forge.com.cursee.more_bows_and_arrows.core.util.CommonEffectsUtil;
import forge.com.cursee.more_bows_and_arrows.core.util.PaperEffectsUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TieredBowItem
extends BowItem {
    public final BowTier tier;

    public TieredBowItem(BowTier tier) {
        super(new Item.Properties().m_41499_(tier.defaultDurability()));
        this.tier = tier;
    }

    public int m_8105_(@NotNull ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof TieredBowItem) {
            TieredBowItem tieredBowItem = (TieredBowItem)item;
            if (tieredBowItem.tier == BowTier.NETHERITE) {
                return 36000;
            }
        }
        return super.m_8105_(itemStack);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        if (!(itemStack.m_41720_() instanceof TieredBowItem)) {
            return;
        }
        BowTier instanceTier = this.tier;
        if (instanceTier == BowTier.BAMBOO) {
            instanceTier = BowTier.WOOD;
        }
        if (instanceTier == BowTier.STRIPPED_BAMBOO) {
            instanceTier = BowTier.STRIPPED_WOOD;
        }
        components.add((Component)Component.m_237115_((String)("lore.more_bows_and_arrows." + instanceTier.toString().toLowerCase() + "_bow1")));
        components.add((Component)Component.m_237115_((String)("lore.more_bows_and_arrows." + instanceTier.toString().toLowerCase() + "_bow2")));
        components.add((Component)Component.m_237115_((String)("lore.more_bows_and_arrows." + instanceTier.toString().toLowerCase() + "_bow_damage")));
        super.m_7373_(itemStack, level, components, flag);
    }

    public void playerAttacksEntity(Player player, LivingEntity livingEntity) {
        switch (this.tier) {
            case BLAZE_ROD: {
                livingEntity.m_20254_(2);
                break;
            }
            case BONE: {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 1));
                break;
            }
            case LIGHTNING_ROD: {
                CommonEffectsUtil.lightingCausedByPlayer(player, livingEntity.m_20183_());
                break;
            }
            case PAPER: {
                PaperEffectsUtil.randomEntityEffects(player, livingEntity);
            }
        }
    }

    public void playerAttacksBlock(Player player, BlockHitResult blockHitResult) {
        switch (this.tier) {
            case BLAZE_ROD: {
                CommonEffectsUtil.lightOrIgniteBlock(blockHitResult, player.m_9236_());
                break;
            }
            case LIGHTNING_ROD: {
                CommonEffectsUtil.lightingCausedByPlayer(player, blockHitResult.m_82425_());
                break;
            }
            case PAPER: {
                PaperEffectsUtil.randomBlockEffects(player, blockHitResult);
            }
        }
    }
}

